//----------------------------------------------------------------------------
//
// Copyright (C) Sartorius Stedim Data Analytics AB 2017 -
//
// Use, modification and distribution are subject to the Boost Software
// License, Version 1.0. (See http://www.boost.org/LICENSE_1_0.txt)
//
//----------------------------------------------------------------------------

#ifndef _SQPRUNNER_H_
#define _SQPRUNNER_H_

#include <stdio.h>

#include "SIMCAQP.h"
#include "SQFileReader.h"

#if defined(_WIN32) && !defined(__cplusplus)
#define strdup _strdup
#endif

#ifdef __cplusplus
extern "C" {
#endif 

   typedef struct SQPRunnerStruct
   {
      char* mszUSPName;
      char* mszPredsetNames;
      char* mszPluginPath;
      SQ_Project mProjectHandle;
   } SQPRunner;

   int SQPRunner_Init(SQPRunner* pObj, char* szUSPName, char* mszPredsetNames, char* mszPluginPath);
   void SQPRunner_Run(SQPRunner* pObj,FILE* pOut, FILE* pErr);
   void SQPRunner_Destroy(SQPRunner* pObj);
   void SQPRunner_PrintVectorData(SQ_VectorData pVectorData, FILE* pOut);
   void SQPRunner_PrintStringVector(SQ_StringVector pStringVector, const char szSeparator, FILE* pOut);



#ifdef __cplusplus
}
#endif /*__cplusplus*/


#endif // _SQPRUNNER_H_
